
package kom.itbeankit.common;


import java.util.Vector;
import java.awt.*;
import kom.itbeankit.common.ItFilename;

public class ItBeanPin
{
	protected ItFilename filename;
	protected boolean inputPin;
	protected java.util.Vector datatype;

/** Standard Constructor.
*/
	public ItBeanPin()
	{
		//{{INIT_CONTROLS
		//}}
	}
    /**
    * constructs a beanpin with all datatypes it can accept / puts out
    */
    public ItBeanPin(boolean bo,Vector dt) {
	    this.inputPin=bo;
	    this.datatype=dt;
    }

    /** The Datatypes this Pin accepts / throws out.
    * This method can be used to determine the compatibility of
    * two pins
    */
	public java.util.Vector getDatatype()
	{
		return this.datatype;
	}

	/** The FileName this Pin STORES its data in.
	* @returns ItFilename
	*/
	public ItFilename getFilename()
	{
	    return this.filename;
	}

	/** Type is True for an Input Pin, otherwise it is an OutputPin
	* @returns Type of the Pin
	*/
	public boolean isInputPin()
	{
		return this.inputPin;
	}

    /** Sets the ItFilename the Pin should LOAD from the DataPool.
    * The Outputfilename is generated by the bean internally.
    */
	public void setFilename(ItFilename filename)
	{
	    this.filename=filename;
	}
	//{{DECLARE_CONTROLS
	//}}

    /** Sets the Type of the Pin (In- or Output)
    * This method is not used by the Construction Kit
    */
	public void setInputPin(boolean type)
	{
			this.inputPin = type;
	}

	/** Sets the Datatypes this Pin can handle.This method will
	* not be used by the Construction Kit.
	*/
	public void setDatatype(java.util.Vector datatype)
	{
		this.datatype = datatype;
	}

}